package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartInstanceRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StartInstanceRequest = {
    import StartInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.StartInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.StartInstanceRequest
      .wrap(buildAwsValue())
}
object StartInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.StartInstanceRequest =
      io.github.vigoo.zioaws.lightsail.model
        .StartInstanceRequest(instanceNameValue)
    def instanceNameValue: ResourceName
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.StartInstanceRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
  ): io.github.vigoo.zioaws.lightsail.model.StartInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
