package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceLocation(
    availabilityZone: Option[String] = None,
    regionName: Option[io.github.vigoo.zioaws.lightsail.model.RegionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResourceLocation = {
    import ResourceLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceLocation
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(regionName.map(value => value.unwrap))(_.regionName)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ResourceLocation
      .wrap(buildAwsValue())
}
object ResourceLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ResourceLocation =
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation(
        availabilityZoneValue.map(value => value),
        regionNameValue.map(value => value)
      )
    def availabilityZoneValue: Option[String]
    def regionNameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RegionName]
    def availabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def regionName: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RegionName
    ] = AwsError.unwrapOptionField("regionName", regionNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ) extends io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly {
    override def availabilityZoneValue: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override def regionNameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RegionName] = scala
      .Option(impl.regionName())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RegionName.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ): io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly =
    new Wrapper(impl)
}
