package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RebootRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest = {
    import RebootRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object RebootRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseRequest =
      io.github.vigoo.zioaws.lightsail.model
        .RebootRelationalDatabaseRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
  ): io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
