package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Timestamp
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricDatapoint(
    average: Option[Double] = None,
    maximum: Option[Double] = None,
    minimum: Option[Double] = None,
    sampleCount: Option[Double] = None,
    sum: Option[Double] = None,
    timestamp: Option[Timestamp] = None,
    unit: Option[io.github.vigoo.zioaws.lightsail.model.MetricUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MetricDatapoint = {
    import MetricDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MetricDatapoint
      .builder()
      .optionallyWith(average.map(value => value: java.lang.Double))(_.average)
      .optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum)
      .optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum)
      .optionallyWith(sampleCount.map(value => value: java.lang.Double))(
        _.sampleCount
      )
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .optionallyWith(timestamp.map(value => value: Instant))(_.timestamp)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.wrap(buildAwsValue())
}
object MetricDatapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.MetricDatapoint =
      io.github.vigoo.zioaws.lightsail.model.MetricDatapoint(
        averageValue.map(value => value),
        maximumValue.map(value => value),
        minimumValue.map(value => value),
        sampleCountValue.map(value => value),
        sumValue.map(value => value),
        timestampValue.map(value => value),
        unitValue.map(value => value)
      )
    def averageValue: Option[Double]
    def maximumValue: Option[Double]
    def minimumValue: Option[Double]
    def sampleCountValue: Option[Double]
    def sumValue: Option[Double]
    def timestampValue: Option[Timestamp]
    def unitValue: Option[io.github.vigoo.zioaws.lightsail.model.MetricUnit]
    def average: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("average", averageValue)
    def maximum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("maximum", maximumValue)
    def minimum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("minimum", minimumValue)
    def sampleCount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sampleCount", sampleCountValue)
    def sum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sum", sumValue)
    def timestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestampValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.MetricUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ) extends io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly {
    override def averageValue: Option[Double] =
      scala.Option(impl.average()).map(value => value: Double)
    override def maximumValue: Option[Double] =
      scala.Option(impl.maximum()).map(value => value: Double)
    override def minimumValue: Option[Double] =
      scala.Option(impl.minimum()).map(value => value: Double)
    override def sampleCountValue: Option[Double] =
      scala.Option(impl.sampleCount()).map(value => value: Double)
    override def sumValue: Option[Double] =
      scala.Option(impl.sum()).map(value => value: Double)
    override def timestampValue: Option[Timestamp] =
      scala.Option(impl.timestamp()).map(value => value: Timestamp)
    override def unitValue
        : Option[io.github.vigoo.zioaws.lightsail.model.MetricUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.MetricUnit.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ): io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly =
    new Wrapper(impl)
}
