package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceSnapshot(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    state: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState
    ] = None,
    progress: Option[String] = None,
    fromAttachedDisks: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Disk]
    ] = None,
    fromInstanceName: Option[ResourceName] = None,
    fromInstanceArn: Option[NonEmptyString] = None,
    fromBlueprintId: Option[String] = None,
    fromBundleId: Option[String] = None,
    isFromAutoSnapshot: Option[Boolean] = None,
    sizeInGb: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceSnapshot = {
    import InstanceSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromAttachedDisks)
      .optionallyWith(fromInstanceName.map(value => value: java.lang.String))(
        _.fromInstanceName
      )
      .optionallyWith(fromInstanceArn.map(value => value: java.lang.String))(
        _.fromInstanceArn
      )
      .optionallyWith(fromBlueprintId.map(value => value: java.lang.String))(
        _.fromBlueprintId
      )
      .optionallyWith(fromBundleId.map(value => value: java.lang.String))(
        _.fromBundleId
      )
      .optionallyWith(
        isFromAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.isFromAutoSnapshot)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot
      .wrap(buildAwsValue())
}
object InstanceSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot =
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        stateValue.map(value => value),
        progressValue.map(value => value),
        fromAttachedDisksValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        fromInstanceNameValue.map(value => value),
        fromInstanceArnValue.map(value => value),
        fromBlueprintIdValue.map(value => value),
        fromBundleIdValue.map(value => value),
        isFromAutoSnapshotValue.map(value => value),
        sizeInGbValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState]
    def progressValue: Option[String]
    def fromAttachedDisksValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly]]
    def fromInstanceNameValue: Option[ResourceName]
    def fromInstanceArnValue: Option[NonEmptyString]
    def fromBlueprintIdValue: Option[String]
    def fromBundleIdValue: Option[String]
    def isFromAutoSnapshotValue: Option[Boolean]
    def sizeInGbValue: Option[Integer]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def progress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progressValue)
    def fromAttachedDisks: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly
    ]] = AwsError.unwrapOptionField("fromAttachedDisks", fromAttachedDisksValue)
    def fromInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fromInstanceName", fromInstanceNameValue)
    def fromInstanceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromInstanceArn", fromInstanceArnValue)
    def fromBlueprintId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fromBlueprintId", fromBlueprintIdValue)
    def fromBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fromBundleId", fromBundleIdValue)
    def isFromAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isFromAutoSnapshot", isFromAutoSnapshotValue)
    def sizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState] =
      scala
        .Option(impl.state())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState
            .wrap(value)
        )
    override def progressValue: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override def fromAttachedDisksValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly]] =
      scala
        .Option(impl.fromAttachedDisks())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Disk.wrap(item)
          }.toList
        )
    override def fromInstanceNameValue: Option[ResourceName] =
      scala.Option(impl.fromInstanceName()).map(value => value: ResourceName)
    override def fromInstanceArnValue: Option[NonEmptyString] =
      scala.Option(impl.fromInstanceArn()).map(value => value: NonEmptyString)
    override def fromBlueprintIdValue: Option[String] =
      scala.Option(impl.fromBlueprintId()).map(value => value: String)
    override def fromBundleIdValue: Option[String] =
      scala.Option(impl.fromBundleId()).map(value => value: String)
    override def isFromAutoSnapshotValue: Option[Boolean] =
      scala.Option(impl.isFromAutoSnapshot()).map(value => value: Boolean)
    override def sizeInGbValue: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
  ): io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly =
    new Wrapper(impl)
}
