package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HeaderObject(
    option: Option[io.github.vigoo.zioaws.lightsail.model.ForwardValues] = None,
    headersAllowList: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.HeaderEnum]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.HeaderObject = {
    import HeaderObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.HeaderObject
      .builder()
      .optionallyWith(option.map(value => value.unwrap))(_.option)
      .optionallyWith(
        headersAllowList.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.headersAllowListWithStrings)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.HeaderObject.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.HeaderObject.wrap(buildAwsValue())
}
object HeaderObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.HeaderObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.HeaderObject =
      io.github.vigoo.zioaws.lightsail.model.HeaderObject(
        optionValue.map(value => value),
        headersAllowListValue.map(value => value)
      )
    def optionValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ForwardValues]
    def headersAllowListValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.HeaderEnum]]
    def option: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ForwardValues
    ] = AwsError.unwrapOptionField("option", optionValue)
    def headersAllowList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.HeaderEnum
    ]] = AwsError.unwrapOptionField("headersAllowList", headersAllowListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.HeaderObject
  ) extends io.github.vigoo.zioaws.lightsail.model.HeaderObject.ReadOnly {
    override def optionValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ForwardValues] = scala
      .Option(impl.option())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ForwardValues.wrap(value)
      )
    override def headersAllowListValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.HeaderEnum]] =
      scala
        .Option(impl.headersAllowList())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.HeaderEnum.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.HeaderObject
  ): io.github.vigoo.zioaws.lightsail.model.HeaderObject.ReadOnly = new Wrapper(
    impl
  )
}
