package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest = {
    import GetStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
      .builder()
      .staticIpName(staticIpName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetStaticIpRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetStaticIpRequest
      .wrap(buildAwsValue())
}
object GetStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetStaticIpRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: ResourceName
    def staticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetStaticIpRequest.ReadOnly {
    override def staticIpNameValue: ResourceName =
      impl.staticIpName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetStaticIpRequest.ReadOnly =
    new Wrapper(impl)
}
