package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetKeyPairRequest(keyPairName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest = {
    import GetKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
      .builder()
      .keyPairName(keyPairName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetKeyPairRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetKeyPairRequest
      .wrap(buildAwsValue())
}
object GetKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetKeyPairRequest =
      io.github.vigoo.zioaws.lightsail.model.GetKeyPairRequest(keyPairNameValue)
    def keyPairNameValue: ResourceName
    def keyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetKeyPairRequest.ReadOnly {
    override def keyPairNameValue: ResourceName =
      impl.keyPairName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetKeyPairRequest.ReadOnly =
    new Wrapper(impl)
}
