package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstancePortStatesRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest = {
    import GetInstancePortStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesRequest
      .wrap(buildAwsValue())
}
object GetInstancePortStatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetInstancePortStatesRequest(instanceNameValue)
    def instanceNameValue: ResourceName
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesRequest.ReadOnly =
    new Wrapper(impl)
}
