package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCloudFormationStackRecordsRequest(
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest = {
    import GetCloudFormationStackRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsRequest
      .wrap(buildAwsValue())
}
object GetCloudFormationStackRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetCloudFormationStackRecordsRequest(
          pageTokenValue.map(value => value)
        )
    def pageTokenValue: Option[String]
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsRequest.ReadOnly {
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsRequest.ReadOnly =
    new Wrapper(impl)
}
