package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetActiveNamesResponse(
    activeNames: Option[Iterable[String]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse = {
    import GetActiveNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
      .builder()
      .optionallyWith(
        activeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.activeNames)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse
      .wrap(buildAwsValue())
}
object GetActiveNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse(
        activeNamesValue.map(value => value),
        nextPageTokenValue.map(value => value)
      )
    def activeNamesValue: Option[List[String]]
    def nextPageTokenValue: Option[String]
    def activeNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("activeNames", activeNamesValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly {
    override def activeNamesValue: Option[List[String]] = scala
      .Option(impl.activeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly =
    new Wrapper(impl)
}
