package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteLoadBalancerTlsCertificateRequest(
    loadBalancerName: ResourceName,
    certificateName: ResourceName,
    force: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest = {
    import DeleteLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .certificateName(certificateName: java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
      .wrap(buildAwsValue())
}
object DeleteLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteLoadBalancerTlsCertificateRequest(
          loadBalancerNameValue,
          certificateNameValue,
          forceValue.map(value => value)
        )
    def loadBalancerNameValue: ResourceName
    def certificateNameValue: ResourceName
    def forceValue: Option[Boolean]
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
    def certificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateNameValue)
    def force: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", forceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
    override def certificateNameValue: ResourceName =
      impl.certificateName(): ResourceName
    override def forceValue: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
