package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  SensitiveString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    availabilityZone: Option[String] = None,
    relationalDatabaseBlueprintId: String,
    relationalDatabaseBundleId: String,
    masterDatabaseName: String,
    masterUsername: String,
    masterUserPassword: Option[SensitiveString] = None,
    preferredBackupWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    publiclyAccessible: Option[Boolean] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest = {
    import CreateRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .relationalDatabaseBlueprintId(
        relationalDatabaseBlueprintId: java.lang.String
      )
      .relationalDatabaseBundleId(relationalDatabaseBundleId: java.lang.String)
      .masterDatabaseName(masterDatabaseName: java.lang.String)
      .masterUsername(masterUsername: java.lang.String)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object CreateRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseRequest(
        relationalDatabaseNameValue,
        availabilityZoneValue.map(value => value),
        relationalDatabaseBlueprintIdValue,
        relationalDatabaseBundleIdValue,
        masterDatabaseNameValue,
        masterUsernameValue,
        masterUserPasswordValue.map(value => value),
        preferredBackupWindowValue.map(value => value),
        preferredMaintenanceWindowValue.map(value => value),
        publiclyAccessibleValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def relationalDatabaseNameValue: ResourceName
    def availabilityZoneValue: Option[String]
    def relationalDatabaseBlueprintIdValue: String
    def relationalDatabaseBundleIdValue: String
    def masterDatabaseNameValue: String
    def masterUsernameValue: String
    def masterUserPasswordValue: Option[SensitiveString]
    def preferredBackupWindowValue: Option[String]
    def preferredMaintenanceWindowValue: Option[String]
    def publiclyAccessibleValue: Option[Boolean]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def availabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def relationalDatabaseBlueprintId: ZIO[Any, Nothing, String] =
      ZIO.succeed(relationalDatabaseBlueprintIdValue)
    def relationalDatabaseBundleId: ZIO[Any, Nothing, String] =
      ZIO.succeed(relationalDatabaseBundleIdValue)
    def masterDatabaseName: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterDatabaseNameValue)
    def masterUsername: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUsernameValue)
    def masterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def preferredBackupWindow: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindowValue
      )
    def publiclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def availabilityZoneValue: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override def relationalDatabaseBlueprintIdValue: String =
      impl.relationalDatabaseBlueprintId(): String
    override def relationalDatabaseBundleIdValue: String =
      impl.relationalDatabaseBundleId(): String
    override def masterDatabaseNameValue: String =
      impl.masterDatabaseName(): String
    override def masterUsernameValue: String = impl.masterUsername(): String
    override def masterUserPasswordValue: Option[SensitiveString] = scala
      .Option(impl.masterUserPassword())
      .map(value => value: SensitiveString)
    override def preferredBackupWindowValue: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def preferredMaintenanceWindowValue: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override def publiclyAccessibleValue: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
