package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  DomainName,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLoadBalancerTlsCertificateRequest(
    loadBalancerName: ResourceName,
    certificateName: ResourceName,
    certificateDomainName: DomainName,
    certificateAlternativeNames: Option[Iterable[DomainName]] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest = {
    import CreateLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .certificateName(certificateName: java.lang.String)
      .certificateDomainName(certificateDomainName: java.lang.String)
      .optionallyWith(
        certificateAlternativeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.certificateAlternativeNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateRequest
      .wrap(buildAwsValue())
}
object CreateLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateRequest =
      io.github.vigoo.zioaws.lightsail.model
        .CreateLoadBalancerTlsCertificateRequest(
          loadBalancerNameValue,
          certificateNameValue,
          certificateDomainNameValue,
          certificateAlternativeNamesValue.map(value => value),
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def loadBalancerNameValue: ResourceName
    def certificateNameValue: ResourceName
    def certificateDomainNameValue: DomainName
    def certificateAlternativeNamesValue: Option[List[DomainName]]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
    def certificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateNameValue)
    def certificateDomainName: ZIO[Any, Nothing, DomainName] =
      ZIO.succeed(certificateDomainNameValue)
    def certificateAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "certificateAlternativeNames",
        certificateAlternativeNamesValue
      )
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
    override def certificateNameValue: ResourceName =
      impl.certificateName(): ResourceName
    override def certificateDomainNameValue: DomainName =
      impl.certificateDomainName(): DomainName
    override def certificateAlternativeNamesValue: Option[List[DomainName]] =
      scala
        .Option(impl.certificateAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            item: DomainName
          }.toList
        )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
