package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateInstancesRequest(
    instanceNames: Iterable[String],
    availabilityZone: String,
    customImageName: Option[ResourceName] = None,
    blueprintId: NonEmptyString,
    bundleId: NonEmptyString,
    userData: Option[String] = None,
    keyPairName: Option[ResourceName] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    addOns: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AddOnRequest]
    ] = None,
    ipAddressType: Option[
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest = {
    import CreateInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
      .builder()
      .instanceNames(instanceNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(customImageName.map(value => value: java.lang.String))(
        _.customImageName
      )
      .blueprintId(blueprintId: java.lang.String)
      .bundleId(bundleId: java.lang.String)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(keyPairName.map(value => value: java.lang.String))(
        _.keyPairName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateInstancesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateInstancesRequest
      .wrap(buildAwsValue())
}
object CreateInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateInstancesRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateInstancesRequest(
        instanceNamesValue,
        availabilityZoneValue,
        customImageNameValue.map(value => value),
        blueprintIdValue,
        bundleIdValue,
        userDataValue.map(value => value),
        keyPairNameValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        addOnsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        ipAddressTypeValue.map(value => value)
      )
    def instanceNamesValue: List[String]
    def availabilityZoneValue: String
    def customImageNameValue: Option[ResourceName]
    def blueprintIdValue: NonEmptyString
    def bundleIdValue: NonEmptyString
    def userDataValue: Option[String]
    def keyPairNameValue: Option[ResourceName]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ]
    def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType]
    def instanceNames: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(instanceNamesValue)
    def availabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZoneValue)
    def customImageName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("customImageName", customImageNameValue)
    def blueprintId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(blueprintIdValue)
    def bundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleIdValue)
    def userData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userDataValue)
    def keyPairName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("keyPairName", keyPairNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOnsValue)
    def ipAddressType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateInstancesRequest.ReadOnly {
    override def instanceNamesValue: List[String] = impl
      .instanceNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override def availabilityZoneValue: String = impl.availabilityZone(): String
    override def customImageNameValue: Option[ResourceName] =
      scala.Option(impl.customImageName()).map(value => value: ResourceName)
    override def blueprintIdValue: NonEmptyString =
      impl.blueprintId(): NonEmptyString
    override def bundleIdValue: NonEmptyString = impl.bundleId(): NonEmptyString
    override def userDataValue: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override def keyPairNameValue: Option[ResourceName] =
      scala.Option(impl.keyPairName()).map(value => value: ResourceName)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ] = scala
      .Option(impl.addOns())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AddOnRequest.wrap(item)
        }.toList
      )
    override def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.IpAddressType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
