package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ContainerName,
  ContainerServiceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceDeploymentRequest(
    serviceName: ContainerServiceName,
    containers: Option[
      Map[ContainerName, io.github.vigoo.zioaws.lightsail.model.Container]
    ] = None,
    publicEndpoint: Option[
      io.github.vigoo.zioaws.lightsail.model.EndpointRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest = {
    import CreateContainerServiceDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .optionallyWith(
        containers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.containers)
      .optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(
        _.publicEndpoint
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentRequest
      .wrap(buildAwsValue())
}
object CreateContainerServiceDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentRequest =
      io.github.vigoo.zioaws.lightsail.model
        .CreateContainerServiceDeploymentRequest(
          serviceNameValue,
          containersValue.map(value =>
            value.map({ case (key, value) =>
              key -> value.editable
            })
          ),
          publicEndpointValue.map(value => value.editable)
        )
    def serviceNameValue: ContainerServiceName
    def containersValue: Option[Map[
      ContainerName,
      io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly
    ]]
    def publicEndpointValue: Option[
      io.github.vigoo.zioaws.lightsail.model.EndpointRequest.ReadOnly
    ]
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
    def containers: ZIO[Any, AwsError, Map[
      ContainerName,
      io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containersValue)
    def publicEndpoint: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.EndpointRequest.ReadOnly
    ] = AwsError.unwrapOptionField("publicEndpoint", publicEndpointValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
    override def containersValue: Option[Map[
      ContainerName,
      io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly
    ]] = scala
      .Option(impl.containers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: ContainerName) -> io.github.vigoo.zioaws.lightsail.model.Container
              .wrap(value)
          })
          .toMap
      )
    override def publicEndpointValue: Option[
      io.github.vigoo.zioaws.lightsail.model.EndpointRequest.ReadOnly
    ] = scala
      .Option(impl.publicEndpoint())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.EndpointRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
