package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBucketAccessKeyResponse(
    accessKey: Option[io.github.vigoo.zioaws.lightsail.model.AccessKey] = None,
    operations: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Operation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse = {
    import CreateBucketAccessKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
      .builder()
      .optionallyWith(accessKey.map(value => value.buildAwsValue()))(
        _.accessKey
      )
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse
      .wrap(buildAwsValue())
}
object CreateBucketAccessKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse =
      io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse(
        accessKeyValue.map(value => value.editable),
        operationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def accessKeyValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly]
    def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ]
    def accessKey: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly
    ] = AwsError.unwrapOptionField("accessKey", accessKeyValue)
    def operations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ]] = AwsError.unwrapOptionField("operations", operationsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly {
    override def accessKeyValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly] =
      scala
        .Option(impl.accessKey())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.AccessKey.wrap(value)
        )
    override def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly =
    new Wrapper(impl)
}
