package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachLoadBalancerTlsCertificateRequest(
    loadBalancerName: ResourceName,
    certificateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest = {
    import AttachLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .certificateName(certificateName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateRequest
      .wrap(buildAwsValue())
}
object AttachLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateRequest =
      io.github.vigoo.zioaws.lightsail.model
        .AttachLoadBalancerTlsCertificateRequest(
          loadBalancerNameValue,
          certificateNameValue
        )
    def loadBalancerNameValue: ResourceName
    def certificateNameValue: ResourceName
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
    def certificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
    override def certificateNameValue: ResourceName =
      impl.certificateName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
  ): io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
