package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccessKeyLastUsed(
    lastUsedDate: Option[IsoDate] = None,
    region: Option[String] = None,
    serviceName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed = {
    import AccessKeyLastUsed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
      .builder()
      .optionallyWith(lastUsedDate.map(value => value: Instant))(_.lastUsedDate)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed
      .wrap(buildAwsValue())
}
object AccessKeyLastUsed {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed =
      io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed(
        lastUsedDateValue.map(value => value),
        regionValue.map(value => value),
        serviceNameValue.map(value => value)
      )
    def lastUsedDateValue: Option[IsoDate]
    def regionValue: Option[String]
    def serviceNameValue: Option[String]
    def lastUsedDate: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("lastUsedDate", lastUsedDateValue)
    def region: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", regionValue)
    def serviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
  ) extends io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed.ReadOnly {
    override def lastUsedDateValue: Option[IsoDate] =
      scala.Option(impl.lastUsedDate()).map(value => value: IsoDate)
    override def regionValue: Option[String] =
      scala.Option(impl.region()).map(value => value: String)
    override def serviceNameValue: Option[String] =
      scala.Option(impl.serviceName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
  ): io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed.ReadOnly =
    new Wrapper(impl)
}
