package io.github.vigoo.zioaws.lightsail
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type AutoSnapshotDate = String
    type Base64 = String
    type BucketName = String
    type CertificateName = String
    type ContainerLabel = String
    type ContainerName = String
    type ContainerServiceName = String
    type ContainerServiceScale = Int
    type DomainEntryOptionsKeys = String
    type DomainEntryType = String
    type DomainName = String
    type EligibleToRenew = String
    type IAMAccessKeyId = String
    type InUseResourceCount = Int
    type IncludeCertificateDetails = Boolean
    type Integer = Int
    type IpAddress = String
    type Ipv6Address = String
    type IsoDate = Instant
    type IssuerCA = String
    type KeyAlgorithm = String
    type MetricPeriod = Int
    type NonEmptyString = String
    type Port = Int
    type RenewalStatusReason = String
    type RequestFailureReason = String
    type ResourceArn = String
    type ResourceName = String
    type RevocationReason = String
    type SensitiveString = String
    type SerialNumber = String
    type StringMax256 = String
    type TagKey = String
    type TagValue = String
    type TimeOfDay = String
    type Timestamp = Instant
  }
  type AccessKeyList = List[AccessKey]
  type AccessReceiverList = List[ResourceReceivingAccess]
  type AddOnList = List[AddOn]
  type AddOnRequestList = List[AddOnRequest]
  type AlarmsList = List[Alarm]
  type AttachedDiskList = List[AttachedDisk]
  type AttachedDiskMap = Map[primitives.ResourceName, Iterable[DiskMap]]
  type AutoSnapshotDetailsList = List[AutoSnapshotDetails]
  type AvailabilityZoneList = List[AvailabilityZone]
  type BlueprintList = List[Blueprint]
  type BucketBundleList = List[BucketBundle]
  type BucketList = List[Bucket]
  type BundleList = List[Bundle]
  type CacheBehaviorList = List[CacheBehaviorPerPath]
  type CertificateStatusList = List[CertificateStatus]
  type CertificateSummaryList = List[CertificateSummary]
  type CloudFormationStackRecordList = List[CloudFormationStackRecord]
  type CloudFormationStackRecordSourceInfoList = List[CloudFormationStackRecordSourceInfo]
  type ContactMethodsList = List[ContactMethod]
  type ContactProtocolsList = List[ContactProtocol]
  type ContainerImageList = List[ContainerImage]
  type ContainerMap = Map[primitives.ContainerName, Container]
  type ContainerServiceDeploymentList = List[ContainerServiceDeployment]
  type ContainerServiceList = List[ContainerService]
  type ContainerServiceLogEventList = List[ContainerServiceLogEvent]
  type ContainerServiceMetadataEntry = Map[String, String]
  type ContainerServiceMetadataEntryList = List[Map[String, String]]
  type ContainerServicePowerList = List[ContainerServicePower]
  type ContainerServicePublicDomains = Map[String, Iterable[String]]
  type ContainerServicePublicDomainsList = List[String]
  type DiskInfoList = List[DiskInfo]
  type DiskList = List[Disk]
  type DiskMapList = List[DiskMap]
  type DiskSnapshotList = List[DiskSnapshot]
  type DistributionBundleList = List[DistributionBundle]
  type DistributionList = List[LightsailDistribution]
  type DomainEntryList = List[DomainEntry]
  type DomainEntryOptions = Map[primitives.DomainEntryOptionsKeys, String]
  type DomainList = List[Domain]
  type DomainNameList = List[primitives.DomainName]
  type DomainValidationRecordList = List[DomainValidationRecord]
  type Environment = Map[String, String]
  type ExportSnapshotRecordList = List[ExportSnapshotRecord]
  type HeaderForwardList = List[HeaderEnum]
  type HostKeysList = List[HostKeyAttributes]
  type InstanceEntryList = List[InstanceEntry]
  type InstanceHealthSummaryList = List[InstanceHealthSummary]
  type InstanceList = List[Instance]
  type InstancePlatformList = List[InstancePlatform]
  type InstancePortInfoList = List[InstancePortInfo]
  type InstancePortStateList = List[InstancePortState]
  type InstanceSnapshotList = List[InstanceSnapshot]
  type Ipv6AddressList = List[primitives.Ipv6Address]
  type KeyPairList = List[KeyPair]
  type LoadBalancerConfigurationOptions = Map[LoadBalancerAttributeName, String]
  type LoadBalancerList = List[LoadBalancer]
  type LoadBalancerTlsCertificateDomainValidationOptionList = List[LoadBalancerTlsCertificateDomainValidationOption]
  type LoadBalancerTlsCertificateDomainValidationRecordList = List[LoadBalancerTlsCertificateDomainValidationRecord]
  type LoadBalancerTlsCertificateList = List[LoadBalancerTlsCertificate]
  type LoadBalancerTlsCertificateSummaryList = List[LoadBalancerTlsCertificateSummary]
  type LogEventList = List[LogEvent]
  type MetricDatapointList = List[MetricDatapoint]
  type MetricStatisticList = List[MetricStatistic]
  type NotificationTriggerList = List[AlarmState]
  type OperationList = List[Operation]
  type PartnerIdList = List[primitives.NonEmptyString]
  type PendingMaintenanceActionList = List[PendingMaintenanceAction]
  type PortInfoList = List[PortInfo]
  type PortList = List[primitives.Port]
  type PortMap = Map[String, ContainerServiceProtocol]
  type RegionList = List[Region]
  type RelationalDatabaseBlueprintList = List[RelationalDatabaseBlueprint]
  type RelationalDatabaseBundleList = List[RelationalDatabaseBundle]
  type RelationalDatabaseEventList = List[RelationalDatabaseEvent]
  type RelationalDatabaseList = List[RelationalDatabase]
  type RelationalDatabaseParameterList = List[RelationalDatabaseParameter]
  type RelationalDatabaseSnapshotList = List[RelationalDatabaseSnapshot]
  type ResourceNameList = List[primitives.ResourceName]
  type StaticIpList = List[StaticIp]
  type StringList = List[String]
  type SubjectAlternativeNameList = List[primitives.DomainName]
  type TagKeyList = List[primitives.TagKey]
  type TagList = List[Tag]
}