package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateBucketResponse(bucket: scala.Option[Bucket] = None, operations: scala.Option[Iterable[Operation]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse = {
    import UpdateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse.builder().optionallyWith(bucket.map(value => value.buildAwsValue()))(_.bucket).optionallyWith(operations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.operations).build()
  }
  def asReadOnly: UpdateBucketResponse.ReadOnly = UpdateBucketResponse.wrap(buildAwsValue())
}
object UpdateBucketResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateBucketResponse = UpdateBucketResponse(bucketValue.map(value => value.editable), operationsValue.map(value => value.map { item => 
      item.editable
    }))
    def bucketValue: scala.Option[Bucket.ReadOnly]
    def operationsValue: scala.Option[List[Operation.ReadOnly]]
    def bucket: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Bucket.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bucket", bucketValue)
    def operations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Operation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operations", operationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse) extends UpdateBucketResponse.ReadOnly {
    override def bucketValue: scala.Option[Bucket.ReadOnly] = scala.Option(impl.bucket()).map(value => Bucket.wrap(value))
    override def operationsValue: scala.Option[List[Operation.ReadOnly]] = scala.Option(impl.operations()).map(value => value.asScala.map { item => 
      Operation.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse): ReadOnly = new Wrapper(impl)
}