package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ResourceBucketAccess { def unwrap: software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess }
object ResourceBucketAccess {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess): ResourceBucketAccess = value match {
    case software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.ALLOW =>
      val r = allow
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.DENY =>
      val r = deny
      r
  }
  case object unknownToSdkVersion extends ResourceBucketAccess { override def unwrap: software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess = software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.UNKNOWN_TO_SDK_VERSION }
  case object allow extends ResourceBucketAccess { override def unwrap: software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess = software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.ALLOW }
  case object deny extends ResourceBucketAccess { override def unwrap: software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess = software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.DENY }
}