package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabaseHardware(cpuCount: scala.Option[primitives.Integer] = None, diskSizeInGb: scala.Option[primitives.Integer] = None, ramSizeInGb: scala.Option[Float] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware = {
    import RelationalDatabaseHardware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware.builder().optionallyWith(cpuCount.map(value => value: java.lang.Integer))(_.cpuCount).optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(_.diskSizeInGb).optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(_.ramSizeInGb).build()
  }
  def asReadOnly: RelationalDatabaseHardware.ReadOnly = RelationalDatabaseHardware.wrap(buildAwsValue())
}
object RelationalDatabaseHardware {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabaseHardware = RelationalDatabaseHardware(cpuCountValue.map(value => value), diskSizeInGbValue.map(value => value), ramSizeInGbValue.map(value => value))
    def cpuCountValue: scala.Option[primitives.Integer]
    def diskSizeInGbValue: scala.Option[primitives.Integer]
    def ramSizeInGbValue: scala.Option[Float]
    def cpuCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def diskSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGbValue)
    def ramSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware) extends RelationalDatabaseHardware.ReadOnly {
    override def cpuCountValue: scala.Option[primitives.Integer] = scala.Option(impl.cpuCount()).map(value => value: primitives.Integer)
    override def diskSizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.diskSizeInGb()).map(value => value: primitives.Integer)
    override def ramSizeInGbValue: scala.Option[Float] = scala.Option(impl.ramSizeInGb()).map(value => value: Float)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware): ReadOnly = new Wrapper(impl)
}