package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait RelationalDatabaseEngine { def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine }
object RelationalDatabaseEngine {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine): RelationalDatabaseEngine = value match {
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.MYSQL =>
      val r = mysql
      r
  }
  case object unknownToSdkVersion extends RelationalDatabaseEngine { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.UNKNOWN_TO_SDK_VERSION }
  case object mysql extends RelationalDatabaseEngine { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.MYSQL }
}