package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RegisterContainerImageResponse(containerImage: scala.Option[ContainerImage] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse = {
    import RegisterContainerImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse.builder().optionallyWith(containerImage.map(value => value.buildAwsValue()))(_.containerImage).build()
  }
  def asReadOnly: RegisterContainerImageResponse.ReadOnly = RegisterContainerImageResponse.wrap(buildAwsValue())
}
object RegisterContainerImageResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RegisterContainerImageResponse = RegisterContainerImageResponse(containerImageValue.map(value => value.editable))
    def containerImageValue: scala.Option[ContainerImage.ReadOnly]
    def containerImage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerImage.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerImage", containerImageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse) extends RegisterContainerImageResponse.ReadOnly { override def containerImageValue: scala.Option[ContainerImage.ReadOnly] = scala.Option(impl.containerImage()).map(value => ContainerImage.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse): ReadOnly = new Wrapper(impl)
}