package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RegisterContainerImageRequest(serviceName: primitives.ContainerServiceName, label: primitives.ContainerLabel, digest: String) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest = {
    import RegisterContainerImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest.builder().serviceName(serviceName: java.lang.String).label(label: java.lang.String).digest(digest: java.lang.String).build()
  }
  def asReadOnly: RegisterContainerImageRequest.ReadOnly = RegisterContainerImageRequest.wrap(buildAwsValue())
}
object RegisterContainerImageRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RegisterContainerImageRequest = RegisterContainerImageRequest(serviceNameValue, labelValue, digestValue)
    def serviceNameValue: primitives.ContainerServiceName
    def labelValue: primitives.ContainerLabel
    def digestValue: String
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
    def label: ZIO[Any, Nothing, primitives.ContainerLabel] = ZIO.succeed(labelValue)
    def digest: ZIO[Any, Nothing, String] = ZIO.succeed(digestValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest) extends RegisterContainerImageRequest.ReadOnly {
    override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName
    override def labelValue: primitives.ContainerLabel = impl.label(): primitives.ContainerLabel
    override def digestValue: String = impl.digest(): String
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest): ReadOnly = new Wrapper(impl)
}