package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait PortState { def unwrap: software.amazon.awssdk.services.lightsail.model.PortState }
object PortState {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.PortState): PortState = value match {
    case software.amazon.awssdk.services.lightsail.model.PortState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.PortState.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.lightsail.model.PortState.CLOSED =>
      val r = closed
      r
  }
  case object unknownToSdkVersion extends PortState { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortState = software.amazon.awssdk.services.lightsail.model.PortState.UNKNOWN_TO_SDK_VERSION }
  case object open extends PortState { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortState = software.amazon.awssdk.services.lightsail.model.PortState.OPEN }
  case object closed extends PortState { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortState = software.amazon.awssdk.services.lightsail.model.PortState.CLOSED }
}