package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Operation(id: scala.Option[primitives.NonEmptyString] = None, resourceName: scala.Option[primitives.ResourceName] = None, resourceType: scala.Option[ResourceType] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, isTerminal: scala.Option[Boolean] = None, operationDetails: scala.Option[String] = None, operationType: scala.Option[OperationType] = None, status: scala.Option[OperationStatus] = None, statusChangedAt: scala.Option[primitives.IsoDate] = None, errorCode: scala.Option[String] = None, errorDetails: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Operation = {
    import Operation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Operation.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(resourceName.map(value => value: java.lang.String))(_.resourceName).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(isTerminal.map(value => value: java.lang.Boolean))(_.isTerminal).optionallyWith(operationDetails.map(value => value: java.lang.String))(_.operationDetails).optionallyWith(operationType.map(value => value.unwrap))(_.operationType).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(statusChangedAt.map(value => value: java.time.Instant))(_.statusChangedAt).optionallyWith(errorCode.map(value => value: java.lang.String))(_.errorCode).optionallyWith(errorDetails.map(value => value: java.lang.String))(_.errorDetails).build()
  }
  def asReadOnly: Operation.ReadOnly = Operation.wrap(buildAwsValue())
}
object Operation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Operation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Operation = Operation(idValue.map(value => value), resourceNameValue.map(value => value), resourceTypeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), isTerminalValue.map(value => value), operationDetailsValue.map(value => value), operationTypeValue.map(value => value), statusValue.map(value => value), statusChangedAtValue.map(value => value), errorCodeValue.map(value => value), errorDetailsValue.map(value => value))
    def idValue: scala.Option[primitives.NonEmptyString]
    def resourceNameValue: scala.Option[primitives.ResourceName]
    def resourceTypeValue: scala.Option[ResourceType]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def isTerminalValue: scala.Option[Boolean]
    def operationDetailsValue: scala.Option[String]
    def operationTypeValue: scala.Option[OperationType]
    def statusValue: scala.Option[OperationStatus]
    def statusChangedAtValue: scala.Option[primitives.IsoDate]
    def errorCodeValue: scala.Option[String]
    def errorDetailsValue: scala.Option[String]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def resourceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceName", resourceNameValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def isTerminal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isTerminal", isTerminalValue)
    def operationDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operationDetails", operationDetailsValue)
    def operationType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OperationType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operationType", operationTypeValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OperationStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def statusChangedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusChangedAt", statusChangedAtValue)
    def errorCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("errorCode", errorCodeValue)
    def errorDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("errorDetails", errorDetailsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Operation) extends Operation.ReadOnly {
    override def idValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.id()).map(value => value: primitives.NonEmptyString)
    override def resourceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.resourceName()).map(value => value: primitives.ResourceName)
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def isTerminalValue: scala.Option[Boolean] = scala.Option(impl.isTerminal()).map(value => value: Boolean)
    override def operationDetailsValue: scala.Option[String] = scala.Option(impl.operationDetails()).map(value => value: String)
    override def operationTypeValue: scala.Option[OperationType] = scala.Option(impl.operationType()).map(value => OperationType.wrap(value))
    override def statusValue: scala.Option[OperationStatus] = scala.Option(impl.status()).map(value => OperationStatus.wrap(value))
    override def statusChangedAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.statusChangedAt()).map(value => value: primitives.IsoDate)
    override def errorCodeValue: scala.Option[String] = scala.Option(impl.errorCode()).map(value => value: String)
    override def errorDetailsValue: scala.Option[String] = scala.Option(impl.errorDetails()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Operation): ReadOnly = new Wrapper(impl)
}