package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LoadBalancerTlsCertificateRenewalSummary(renewalStatus: scala.Option[LoadBalancerTlsCertificateRenewalStatus] = None, domainValidationOptions: scala.Option[Iterable[LoadBalancerTlsCertificateDomainValidationOption]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary = {
    import LoadBalancerTlsCertificateRenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.builder().optionallyWith(renewalStatus.map(value => value.unwrap))(_.renewalStatus).optionallyWith(domainValidationOptions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.domainValidationOptions).build()
  }
  def asReadOnly: LoadBalancerTlsCertificateRenewalSummary.ReadOnly = LoadBalancerTlsCertificateRenewalSummary.wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateRenewalSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LoadBalancerTlsCertificateRenewalSummary = LoadBalancerTlsCertificateRenewalSummary(renewalStatusValue.map(value => value), domainValidationOptionsValue.map(value => value.map { item => 
      item.editable
    }))
    def renewalStatusValue: scala.Option[LoadBalancerTlsCertificateRenewalStatus]
    def domainValidationOptionsValue: scala.Option[List[LoadBalancerTlsCertificateDomainValidationOption.ReadOnly]]
    def renewalStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerTlsCertificateRenewalStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("renewalStatus", renewalStatusValue)
    def domainValidationOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LoadBalancerTlsCertificateDomainValidationOption.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainValidationOptions", domainValidationOptionsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary) extends LoadBalancerTlsCertificateRenewalSummary.ReadOnly {
    override def renewalStatusValue: scala.Option[LoadBalancerTlsCertificateRenewalStatus] = scala.Option(impl.renewalStatus()).map(value => LoadBalancerTlsCertificateRenewalStatus.wrap(value))
    override def domainValidationOptionsValue: scala.Option[List[LoadBalancerTlsCertificateDomainValidationOption.ReadOnly]] = scala.Option(impl.domainValidationOptions()).map(value => value.asScala.map { item => 
      LoadBalancerTlsCertificateDomainValidationOption.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary): ReadOnly = new Wrapper(impl)
}