package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceSnapshotInfo(fromBundleId: scala.Option[primitives.NonEmptyString] = None, fromBlueprintId: scala.Option[primitives.NonEmptyString] = None, fromDiskInfo: scala.Option[Iterable[DiskInfo]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo = {
    import InstanceSnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo.builder().optionallyWith(fromBundleId.map(value => value: java.lang.String))(_.fromBundleId).optionallyWith(fromBlueprintId.map(value => value: java.lang.String))(_.fromBlueprintId).optionallyWith(fromDiskInfo.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.fromDiskInfo).build()
  }
  def asReadOnly: InstanceSnapshotInfo.ReadOnly = InstanceSnapshotInfo.wrap(buildAwsValue())
}
object InstanceSnapshotInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceSnapshotInfo = InstanceSnapshotInfo(fromBundleIdValue.map(value => value), fromBlueprintIdValue.map(value => value), fromDiskInfoValue.map(value => value.map { item => 
      item.editable
    }))
    def fromBundleIdValue: scala.Option[primitives.NonEmptyString]
    def fromBlueprintIdValue: scala.Option[primitives.NonEmptyString]
    def fromDiskInfoValue: scala.Option[List[DiskInfo.ReadOnly]]
    def fromBundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromBundleId", fromBundleIdValue)
    def fromBlueprintId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromBlueprintId", fromBlueprintIdValue)
    def fromDiskInfo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DiskInfo.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromDiskInfo", fromDiskInfoValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo) extends InstanceSnapshotInfo.ReadOnly {
    override def fromBundleIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromBundleId()).map(value => value: primitives.NonEmptyString)
    override def fromBlueprintIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromBlueprintId()).map(value => value: primitives.NonEmptyString)
    override def fromDiskInfoValue: scala.Option[List[DiskInfo.ReadOnly]] = scala.Option(impl.fromDiskInfo()).map(value => value.asScala.map { item => 
      DiskInfo.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo): ReadOnly = new Wrapper(impl)
}