package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceSnapshot(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, state: scala.Option[InstanceSnapshotState] = None, progress: scala.Option[String] = None, fromAttachedDisks: scala.Option[Iterable[Disk]] = None, fromInstanceName: scala.Option[primitives.ResourceName] = None, fromInstanceArn: scala.Option[primitives.NonEmptyString] = None, fromBlueprintId: scala.Option[String] = None, fromBundleId: scala.Option[String] = None, isFromAutoSnapshot: scala.Option[Boolean] = None, sizeInGb: scala.Option[primitives.Integer] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceSnapshot = {
    import InstanceSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshot.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(progress.map(value => value: java.lang.String))(_.progress).optionallyWith(fromAttachedDisks.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.fromAttachedDisks).optionallyWith(fromInstanceName.map(value => value: java.lang.String))(_.fromInstanceName).optionallyWith(fromInstanceArn.map(value => value: java.lang.String))(_.fromInstanceArn).optionallyWith(fromBlueprintId.map(value => value: java.lang.String))(_.fromBlueprintId).optionallyWith(fromBundleId.map(value => value: java.lang.String))(_.fromBundleId).optionallyWith(isFromAutoSnapshot.map(value => value: java.lang.Boolean))(_.isFromAutoSnapshot).optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(_.sizeInGb).build()
  }
  def asReadOnly: InstanceSnapshot.ReadOnly = InstanceSnapshot.wrap(buildAwsValue())
}
object InstanceSnapshot {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceSnapshot] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceSnapshot = InstanceSnapshot(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), stateValue.map(value => value), progressValue.map(value => value), fromAttachedDisksValue.map(value => value.map { item => 
      item.editable
    }), fromInstanceNameValue.map(value => value), fromInstanceArnValue.map(value => value), fromBlueprintIdValue.map(value => value), fromBundleIdValue.map(value => value), isFromAutoSnapshotValue.map(value => value), sizeInGbValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def stateValue: scala.Option[InstanceSnapshotState]
    def progressValue: scala.Option[String]
    def fromAttachedDisksValue: scala.Option[List[Disk.ReadOnly]]
    def fromInstanceNameValue: scala.Option[primitives.ResourceName]
    def fromInstanceArnValue: scala.Option[primitives.NonEmptyString]
    def fromBlueprintIdValue: scala.Option[String]
    def fromBundleIdValue: scala.Option[String]
    def isFromAutoSnapshotValue: scala.Option[Boolean]
    def sizeInGbValue: scala.Option[primitives.Integer]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceSnapshotState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def progress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("progress", progressValue)
    def fromAttachedDisks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Disk.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromAttachedDisks", fromAttachedDisksValue)
    def fromInstanceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromInstanceName", fromInstanceNameValue)
    def fromInstanceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromInstanceArn", fromInstanceArnValue)
    def fromBlueprintId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromBlueprintId", fromBlueprintIdValue)
    def fromBundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromBundleId", fromBundleIdValue)
    def isFromAutoSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isFromAutoSnapshot", isFromAutoSnapshotValue)
    def sizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshot) extends InstanceSnapshot.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def stateValue: scala.Option[InstanceSnapshotState] = scala.Option(impl.state()).map(value => InstanceSnapshotState.wrap(value))
    override def progressValue: scala.Option[String] = scala.Option(impl.progress()).map(value => value: String)
    override def fromAttachedDisksValue: scala.Option[List[Disk.ReadOnly]] = scala.Option(impl.fromAttachedDisks()).map(value => value.asScala.map { item => 
      Disk.wrap(item)
    }.toList)
    override def fromInstanceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.fromInstanceName()).map(value => value: primitives.ResourceName)
    override def fromInstanceArnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromInstanceArn()).map(value => value: primitives.NonEmptyString)
    override def fromBlueprintIdValue: scala.Option[String] = scala.Option(impl.fromBlueprintId()).map(value => value: String)
    override def fromBundleIdValue: scala.Option[String] = scala.Option(impl.fromBundleId()).map(value => value: String)
    override def isFromAutoSnapshotValue: scala.Option[Boolean] = scala.Option(impl.isFromAutoSnapshot()).map(value => value: Boolean)
    override def sizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.sizeInGb()).map(value => value: primitives.Integer)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshot): ReadOnly = new Wrapper(impl)
}