package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceHardware(cpuCount: scala.Option[primitives.Integer] = None, disks: scala.Option[Iterable[Disk]] = None, ramSizeInGb: scala.Option[Float] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceHardware = {
    import InstanceHardware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceHardware.builder().optionallyWith(cpuCount.map(value => value: java.lang.Integer))(_.cpuCount).optionallyWith(disks.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.disks).optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(_.ramSizeInGb).build()
  }
  def asReadOnly: InstanceHardware.ReadOnly = InstanceHardware.wrap(buildAwsValue())
}
object InstanceHardware {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceHardware] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceHardware = InstanceHardware(cpuCountValue.map(value => value), disksValue.map(value => value.map { item => 
      item.editable
    }), ramSizeInGbValue.map(value => value))
    def cpuCountValue: scala.Option[primitives.Integer]
    def disksValue: scala.Option[List[Disk.ReadOnly]]
    def ramSizeInGbValue: scala.Option[Float]
    def cpuCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def disks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Disk.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disks", disksValue)
    def ramSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceHardware) extends InstanceHardware.ReadOnly {
    override def cpuCountValue: scala.Option[primitives.Integer] = scala.Option(impl.cpuCount()).map(value => value: primitives.Integer)
    override def disksValue: scala.Option[List[Disk.ReadOnly]] = scala.Option(impl.disks()).map(value => value.asScala.map { item => 
      Disk.wrap(item)
    }.toList)
    override def ramSizeInGbValue: scala.Option[Float] = scala.Option(impl.ramSizeInGb()).map(value => value: Float)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceHardware): ReadOnly = new Wrapper(impl)
}