package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputOrigin(name: scala.Option[primitives.ResourceName] = None, regionName: scala.Option[RegionName] = None, protocolPolicy: scala.Option[OriginProtocolPolicyEnum] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InputOrigin = {
    import InputOrigin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InputOrigin.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(regionName.map(value => value.unwrap))(_.regionName).optionallyWith(protocolPolicy.map(value => value.unwrap))(_.protocolPolicy).build()
  }
  def asReadOnly: InputOrigin.ReadOnly = InputOrigin.wrap(buildAwsValue())
}
object InputOrigin {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InputOrigin] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputOrigin = InputOrigin(nameValue.map(value => value), regionNameValue.map(value => value), protocolPolicyValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def regionNameValue: scala.Option[RegionName]
    def protocolPolicyValue: scala.Option[OriginProtocolPolicyEnum]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def regionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RegionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("regionName", regionNameValue)
    def protocolPolicy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OriginProtocolPolicyEnum] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocolPolicy", protocolPolicyValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InputOrigin) extends InputOrigin.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def regionNameValue: scala.Option[RegionName] = scala.Option(impl.regionName()).map(value => RegionName.wrap(value))
    override def protocolPolicyValue: scala.Option[OriginProtocolPolicyEnum] = scala.Option(impl.protocolPolicy()).map(value => OriginProtocolPolicyEnum.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InputOrigin): ReadOnly = new Wrapper(impl)
}