package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetStaticIpResponse(staticIp: scala.Option[StaticIp] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse = {
    import GetStaticIpResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse.builder().optionallyWith(staticIp.map(value => value.buildAwsValue()))(_.staticIp).build()
  }
  def asReadOnly: GetStaticIpResponse.ReadOnly = GetStaticIpResponse.wrap(buildAwsValue())
}
object GetStaticIpResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetStaticIpResponse = GetStaticIpResponse(staticIpValue.map(value => value.editable))
    def staticIpValue: scala.Option[StaticIp.ReadOnly]
    def staticIp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, StaticIp.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticIp", staticIpValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse) extends GetStaticIpResponse.ReadOnly { override def staticIpValue: scala.Option[StaticIp.ReadOnly] = scala.Option(impl.staticIp()).map(value => StaticIp.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse): ReadOnly = new Wrapper(impl)
}