package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetOperationsResponse(operations: scala.Option[Iterable[Operation]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetOperationsResponse = {
    import GetOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsResponse.builder().optionallyWith(operations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.operations).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetOperationsResponse.ReadOnly = GetOperationsResponse.wrap(buildAwsValue())
}
object GetOperationsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetOperationsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetOperationsResponse = GetOperationsResponse(operationsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def operationsValue: scala.Option[List[Operation.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def operations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Operation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operations", operationsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsResponse) extends GetOperationsResponse.ReadOnly {
    override def operationsValue: scala.Option[List[Operation.ReadOnly]] = scala.Option(impl.operations()).map(value => value.asScala.map { item => 
      Operation.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsResponse): ReadOnly = new Wrapper(impl)
}