package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstancePortStatesResponse(portStates: scala.Option[Iterable[InstancePortState]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse = {
    import GetInstancePortStatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse.builder().optionallyWith(portStates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.portStates).build()
  }
  def asReadOnly: GetInstancePortStatesResponse.ReadOnly = GetInstancePortStatesResponse.wrap(buildAwsValue())
}
object GetInstancePortStatesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstancePortStatesResponse = GetInstancePortStatesResponse(portStatesValue.map(value => value.map { item => 
      item.editable
    }))
    def portStatesValue: scala.Option[List[InstancePortState.ReadOnly]]
    def portStates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InstancePortState.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("portStates", portStatesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse) extends GetInstancePortStatesResponse.ReadOnly {
    override def portStatesValue: scala.Option[List[InstancePortState.ReadOnly]] = scala.Option(impl.portStates()).map(value => value.asScala.map { item => 
      InstancePortState.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse): ReadOnly = new Wrapper(impl)
}