package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDomainResponse(domain: scala.Option[Domain] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDomainResponse = {
    import GetDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainResponse.builder().optionallyWith(domain.map(value => value.buildAwsValue()))(_.domain).build()
  }
  def asReadOnly: GetDomainResponse.ReadOnly = GetDomainResponse.wrap(buildAwsValue())
}
object GetDomainResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDomainResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDomainResponse = GetDomainResponse(domainValue.map(value => value.editable))
    def domainValue: scala.Option[Domain.ReadOnly]
    def domain: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Domain.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domain", domainValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDomainResponse) extends GetDomainResponse.ReadOnly { override def domainValue: scala.Option[Domain.ReadOnly] = scala.Option(impl.domain()).map(value => Domain.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDomainResponse): ReadOnly = new Wrapper(impl)
}