package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDiskRequest(diskName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDiskRequest = {
    import GetDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskRequest.builder().diskName(diskName: java.lang.String).build()
  }
  def asReadOnly: GetDiskRequest.ReadOnly = GetDiskRequest.wrap(buildAwsValue())
}
object GetDiskRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDiskRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDiskRequest = GetDiskRequest(diskNameValue)
    def diskNameValue: primitives.ResourceName
    def diskName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDiskRequest) extends GetDiskRequest.ReadOnly { override def diskNameValue: primitives.ResourceName = impl.diskName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDiskRequest): ReadOnly = new Wrapper(impl)
}