package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerServiceDeploymentsResponse(deployments: scala.Option[Iterable[ContainerServiceDeployment]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse = {
    import GetContainerServiceDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse.builder().optionallyWith(deployments.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.deployments).build()
  }
  def asReadOnly: GetContainerServiceDeploymentsResponse.ReadOnly = GetContainerServiceDeploymentsResponse.wrap(buildAwsValue())
}
object GetContainerServiceDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerServiceDeploymentsResponse = GetContainerServiceDeploymentsResponse(deploymentsValue.map(value => value.map { item => 
      item.editable
    }))
    def deploymentsValue: scala.Option[List[ContainerServiceDeployment.ReadOnly]]
    def deployments: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContainerServiceDeployment.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deployments", deploymentsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse) extends GetContainerServiceDeploymentsResponse.ReadOnly {
    override def deploymentsValue: scala.Option[List[ContainerServiceDeployment.ReadOnly]] = scala.Option(impl.deployments()).map(value => value.asScala.map { item => 
      ContainerServiceDeployment.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse): ReadOnly = new Wrapper(impl)
}