package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCertificatesResponse(certificates: scala.Option[Iterable[CertificateSummary]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse = {
    import GetCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse.builder().optionallyWith(certificates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.certificates).build()
  }
  def asReadOnly: GetCertificatesResponse.ReadOnly = GetCertificatesResponse.wrap(buildAwsValue())
}
object GetCertificatesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCertificatesResponse = GetCertificatesResponse(certificatesValue.map(value => value.map { item => 
      item.editable
    }))
    def certificatesValue: scala.Option[List[CertificateSummary.ReadOnly]]
    def certificates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CertificateSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificates", certificatesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse) extends GetCertificatesResponse.ReadOnly {
    override def certificatesValue: scala.Option[List[CertificateSummary.ReadOnly]] = scala.Option(impl.certificates()).map(value => value.asScala.map { item => 
      CertificateSummary.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse): ReadOnly = new Wrapper(impl)
}