package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAutoSnapshotsResponse(resourceName: scala.Option[primitives.ResourceName] = None, resourceType: scala.Option[ResourceType] = None, autoSnapshots: scala.Option[Iterable[AutoSnapshotDetails]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse = {
    import GetAutoSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse.builder().optionallyWith(resourceName.map(value => value: java.lang.String))(_.resourceName).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(autoSnapshots.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.autoSnapshots).build()
  }
  def asReadOnly: GetAutoSnapshotsResponse.ReadOnly = GetAutoSnapshotsResponse.wrap(buildAwsValue())
}
object GetAutoSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAutoSnapshotsResponse = GetAutoSnapshotsResponse(resourceNameValue.map(value => value), resourceTypeValue.map(value => value), autoSnapshotsValue.map(value => value.map { item => 
      item.editable
    }))
    def resourceNameValue: scala.Option[primitives.ResourceName]
    def resourceTypeValue: scala.Option[ResourceType]
    def autoSnapshotsValue: scala.Option[List[AutoSnapshotDetails.ReadOnly]]
    def resourceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceName", resourceNameValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def autoSnapshots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AutoSnapshotDetails.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoSnapshots", autoSnapshotsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse) extends GetAutoSnapshotsResponse.ReadOnly {
    override def resourceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.resourceName()).map(value => value: primitives.ResourceName)
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def autoSnapshotsValue: scala.Option[List[AutoSnapshotDetails.ReadOnly]] = scala.Option(impl.autoSnapshots()).map(value => value.asScala.map { item => 
      AutoSnapshotDetails.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse): ReadOnly = new Wrapper(impl)
}