package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ExportSnapshotRecordSourceInfo(resourceType: scala.Option[ExportSnapshotRecordSourceType] = None, createdAt: scala.Option[primitives.IsoDate] = None, name: scala.Option[primitives.NonEmptyString] = None, arn: scala.Option[primitives.NonEmptyString] = None, fromResourceName: scala.Option[primitives.NonEmptyString] = None, fromResourceArn: scala.Option[primitives.NonEmptyString] = None, instanceSnapshotInfo: scala.Option[InstanceSnapshotInfo] = None, diskSnapshotInfo: scala.Option[DiskSnapshotInfo] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo = {
    import ExportSnapshotRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo.builder().optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(fromResourceName.map(value => value: java.lang.String))(_.fromResourceName).optionallyWith(fromResourceArn.map(value => value: java.lang.String))(_.fromResourceArn).optionallyWith(instanceSnapshotInfo.map(value => value.buildAwsValue()))(_.instanceSnapshotInfo).optionallyWith(diskSnapshotInfo.map(value => value.buildAwsValue()))(_.diskSnapshotInfo).build()
  }
  def asReadOnly: ExportSnapshotRecordSourceInfo.ReadOnly = ExportSnapshotRecordSourceInfo.wrap(buildAwsValue())
}
object ExportSnapshotRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ExportSnapshotRecordSourceInfo = ExportSnapshotRecordSourceInfo(resourceTypeValue.map(value => value), createdAtValue.map(value => value), nameValue.map(value => value), arnValue.map(value => value), fromResourceNameValue.map(value => value), fromResourceArnValue.map(value => value), instanceSnapshotInfoValue.map(value => value.editable), diskSnapshotInfoValue.map(value => value.editable))
    def resourceTypeValue: scala.Option[ExportSnapshotRecordSourceType]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def nameValue: scala.Option[primitives.NonEmptyString]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def fromResourceNameValue: scala.Option[primitives.NonEmptyString]
    def fromResourceArnValue: scala.Option[primitives.NonEmptyString]
    def instanceSnapshotInfoValue: scala.Option[InstanceSnapshotInfo.ReadOnly]
    def diskSnapshotInfoValue: scala.Option[DiskSnapshotInfo.ReadOnly]
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ExportSnapshotRecordSourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def fromResourceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromResourceName", fromResourceNameValue)
    def fromResourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromResourceArn", fromResourceArnValue)
    def instanceSnapshotInfo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceSnapshotInfo.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceSnapshotInfo", instanceSnapshotInfoValue)
    def diskSnapshotInfo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DiskSnapshotInfo.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskSnapshotInfo", diskSnapshotInfoValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo) extends ExportSnapshotRecordSourceInfo.ReadOnly {
    override def resourceTypeValue: scala.Option[ExportSnapshotRecordSourceType] = scala.Option(impl.resourceType()).map(value => ExportSnapshotRecordSourceType.wrap(value))
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def nameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.name()).map(value => value: primitives.NonEmptyString)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def fromResourceNameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromResourceName()).map(value => value: primitives.NonEmptyString)
    override def fromResourceArnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromResourceArn()).map(value => value: primitives.NonEmptyString)
    override def instanceSnapshotInfoValue: scala.Option[InstanceSnapshotInfo.ReadOnly] = scala.Option(impl.instanceSnapshotInfo()).map(value => InstanceSnapshotInfo.wrap(value))
    override def diskSnapshotInfoValue: scala.Option[DiskSnapshotInfo.ReadOnly] = scala.Option(impl.diskSnapshotInfo()).map(value => DiskSnapshotInfo.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo): ReadOnly = new Wrapper(impl)
}