package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DownloadDefaultKeyPairResponse(publicKeyBase64: scala.Option[primitives.Base64] = None, privateKeyBase64: scala.Option[primitives.Base64] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse = {
    import DownloadDefaultKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse.builder().optionallyWith(publicKeyBase64.map(value => value: java.lang.String))(_.publicKeyBase64).optionallyWith(privateKeyBase64.map(value => value: java.lang.String))(_.privateKeyBase64).build()
  }
  def asReadOnly: DownloadDefaultKeyPairResponse.ReadOnly = DownloadDefaultKeyPairResponse.wrap(buildAwsValue())
}
object DownloadDefaultKeyPairResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DownloadDefaultKeyPairResponse = DownloadDefaultKeyPairResponse(publicKeyBase64Value.map(value => value), privateKeyBase64Value.map(value => value))
    def publicKeyBase64Value: scala.Option[primitives.Base64]
    def privateKeyBase64Value: scala.Option[primitives.Base64]
    def publicKeyBase64: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Base64] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicKeyBase64", publicKeyBase64Value)
    def privateKeyBase64: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Base64] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("privateKeyBase64", privateKeyBase64Value)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse) extends DownloadDefaultKeyPairResponse.ReadOnly {
    override def publicKeyBase64Value: scala.Option[primitives.Base64] = scala.Option(impl.publicKeyBase64()).map(value => value: primitives.Base64)
    override def privateKeyBase64Value: scala.Option[primitives.Base64] = scala.Option(impl.privateKeyBase64()).map(value => value: primitives.Base64)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse): ReadOnly = new Wrapper(impl)
}