package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteContainerServiceRequest(serviceName: primitives.ContainerServiceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest = {
    import DeleteContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest.builder().serviceName(serviceName: java.lang.String).build()
  }
  def asReadOnly: DeleteContainerServiceRequest.ReadOnly = DeleteContainerServiceRequest.wrap(buildAwsValue())
}
object DeleteContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteContainerServiceRequest = DeleteContainerServiceRequest(serviceNameValue)
    def serviceNameValue: primitives.ContainerServiceName
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest) extends DeleteContainerServiceRequest.ReadOnly { override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest): ReadOnly = new Wrapper(impl)
}