package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateContactMethodRequest(protocol: ContactProtocol, contactEndpoint: primitives.StringMax256) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest = {
    import CreateContactMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest.builder().protocol(protocol.unwrap).contactEndpoint(contactEndpoint: java.lang.String).build()
  }
  def asReadOnly: CreateContactMethodRequest.ReadOnly = CreateContactMethodRequest.wrap(buildAwsValue())
}
object CreateContactMethodRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateContactMethodRequest = CreateContactMethodRequest(protocolValue, contactEndpointValue)
    def protocolValue: ContactProtocol
    def contactEndpointValue: primitives.StringMax256
    def protocol: ZIO[Any, Nothing, ContactProtocol] = ZIO.succeed(protocolValue)
    def contactEndpoint: ZIO[Any, Nothing, primitives.StringMax256] = ZIO.succeed(contactEndpointValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest) extends CreateContactMethodRequest.ReadOnly {
    override def protocolValue: ContactProtocol = ContactProtocol.wrap(impl.protocol())
    override def contactEndpointValue: primitives.StringMax256 = impl.contactEndpoint(): primitives.StringMax256
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest): ReadOnly = new Wrapper(impl)
}