package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerServicePower(powerId: scala.Option[String] = None, price: scala.Option[Float] = None, cpuCount: scala.Option[Float] = None, ramSizeInGb: scala.Option[Float] = None, name: scala.Option[String] = None, isActive: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerServicePower = {
    import ContainerServicePower.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServicePower.builder().optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId).optionallyWith(price.map(value => value: java.lang.Float))(_.price).optionallyWith(cpuCount.map(value => value: java.lang.Float))(_.cpuCount).optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(_.ramSizeInGb).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(isActive.map(value => value: java.lang.Boolean))(_.isActive).build()
  }
  def asReadOnly: ContainerServicePower.ReadOnly = ContainerServicePower.wrap(buildAwsValue())
}
object ContainerServicePower {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerServicePower] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerServicePower = ContainerServicePower(powerIdValue.map(value => value), priceValue.map(value => value), cpuCountValue.map(value => value), ramSizeInGbValue.map(value => value), nameValue.map(value => value), isActiveValue.map(value => value))
    def powerIdValue: scala.Option[String]
    def priceValue: scala.Option[Float]
    def cpuCountValue: scala.Option[Float]
    def ramSizeInGbValue: scala.Option[Float]
    def nameValue: scala.Option[String]
    def isActiveValue: scala.Option[Boolean]
    def powerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("powerId", powerIdValue)
    def price: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("price", priceValue)
    def cpuCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def ramSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def isActive: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isActive", isActiveValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower) extends ContainerServicePower.ReadOnly {
    override def powerIdValue: scala.Option[String] = scala.Option(impl.powerId()).map(value => value: String)
    override def priceValue: scala.Option[Float] = scala.Option(impl.price()).map(value => value: Float)
    override def cpuCountValue: scala.Option[Float] = scala.Option(impl.cpuCount()).map(value => value: Float)
    override def ramSizeInGbValue: scala.Option[Float] = scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def isActiveValue: scala.Option[Boolean] = scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower): ReadOnly = new Wrapper(impl)
}