package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerImage(image: scala.Option[String] = None, digest: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerImage = {
    import ContainerImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerImage.builder().optionallyWith(image.map(value => value: java.lang.String))(_.image).optionallyWith(digest.map(value => value: java.lang.String))(_.digest).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).build()
  }
  def asReadOnly: ContainerImage.ReadOnly = ContainerImage.wrap(buildAwsValue())
}
object ContainerImage {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerImage] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerImage = ContainerImage(imageValue.map(value => value), digestValue.map(value => value), createdAtValue.map(value => value))
    def imageValue: scala.Option[String]
    def digestValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def image: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("image", imageValue)
    def digest: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("digest", digestValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerImage) extends ContainerImage.ReadOnly {
    override def imageValue: scala.Option[String] = scala.Option(impl.image()).map(value => value: String)
    override def digestValue: scala.Option[String] = scala.Option(impl.digest()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerImage): ReadOnly = new Wrapper(impl)
}