package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Container(image: scala.Option[String] = None, command: scala.Option[Iterable[String]] = None, environment: scala.Option[Map[String, String]] = None, ports: scala.Option[Map[String, ContainerServiceProtocol]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Container.builder().optionallyWith(image.map(value => value: java.lang.String))(_.image).optionallyWith(command.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.command).optionallyWith(environment.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.environment).optionallyWith(ports.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.unwrap.toString
    }).asJava))(_.portsWithStrings).build()
  }
  def asReadOnly: Container.ReadOnly = Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Container] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Container = Container(imageValue.map(value => value), commandValue.map(value => value), environmentValue.map(value => value), portsValue.map(value => value))
    def imageValue: scala.Option[String]
    def commandValue: scala.Option[List[String]]
    def environmentValue: scala.Option[Map[String, String]]
    def portsValue: scala.Option[Map[String, ContainerServiceProtocol]]
    def image: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("image", imageValue)
    def command: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("command", commandValue)
    def environment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("environment", environmentValue)
    def ports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, ContainerServiceProtocol]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ports", portsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Container) extends Container.ReadOnly {
    override def imageValue: scala.Option[String] = scala.Option(impl.image()).map(value => value: String)
    override def commandValue: scala.Option[List[String]] = scala.Option(impl.command()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def environmentValue: scala.Option[Map[String, String]] = scala.Option(impl.environment()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def portsValue: scala.Option[Map[String, ContainerServiceProtocol]] = scala.Option(impl.ports()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> ContainerServiceProtocol.wrap(value)
    }).toMap)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Container): ReadOnly = new Wrapper(impl)
}