package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContactMethod(contactEndpoint: scala.Option[primitives.NonEmptyString] = None, status: scala.Option[ContactMethodStatus] = None, protocol: scala.Option[ContactProtocol] = None, name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, supportCode: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContactMethod = {
    import ContactMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContactMethod.builder().optionallyWith(contactEndpoint.map(value => value: java.lang.String))(_.contactEndpoint).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(protocol.map(value => value.unwrap))(_.protocol).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).build()
  }
  def asReadOnly: ContactMethod.ReadOnly = ContactMethod.wrap(buildAwsValue())
}
object ContactMethod {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContactMethod] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContactMethod = ContactMethod(contactEndpointValue.map(value => value), statusValue.map(value => value), protocolValue.map(value => value), nameValue.map(value => value), arnValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), supportCodeValue.map(value => value))
    def contactEndpointValue: scala.Option[primitives.NonEmptyString]
    def statusValue: scala.Option[ContactMethodStatus]
    def protocolValue: scala.Option[ContactProtocol]
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def supportCodeValue: scala.Option[String]
    def contactEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("contactEndpoint", contactEndpointValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContactMethodStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def protocol: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContactProtocol] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocol", protocolValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContactMethod) extends ContactMethod.ReadOnly {
    override def contactEndpointValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.contactEndpoint()).map(value => value: primitives.NonEmptyString)
    override def statusValue: scala.Option[ContactMethodStatus] = scala.Option(impl.status()).map(value => ContactMethodStatus.wrap(value))
    override def protocolValue: scala.Option[ContactProtocol] = scala.Option(impl.protocol()).map(value => ContactProtocol.wrap(value))
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContactMethod): ReadOnly = new Wrapper(impl)
}