package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CacheBehaviorPerPath(path: scala.Option[String] = None, behavior: scala.Option[BehaviorEnum] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath = {
    import CacheBehaviorPerPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath.builder().optionallyWith(path.map(value => value: java.lang.String))(_.path).optionallyWith(behavior.map(value => value.unwrap))(_.behavior).build()
  }
  def asReadOnly: CacheBehaviorPerPath.ReadOnly = CacheBehaviorPerPath.wrap(buildAwsValue())
}
object CacheBehaviorPerPath {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CacheBehaviorPerPath = CacheBehaviorPerPath(pathValue.map(value => value), behaviorValue.map(value => value))
    def pathValue: scala.Option[String]
    def behaviorValue: scala.Option[BehaviorEnum]
    def path: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("path", pathValue)
    def behavior: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BehaviorEnum] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("behavior", behaviorValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath) extends CacheBehaviorPerPath.ReadOnly {
    override def pathValue: scala.Option[String] = scala.Option(impl.path()).map(value => value: String)
    override def behaviorValue: scala.Option[BehaviorEnum] = scala.Option(impl.behavior()).map(value => BehaviorEnum.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath): ReadOnly = new Wrapper(impl)
}